/*
 * Decompiled with CFR 0.152.
 */
package org.figuramc.figura.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.figuramc.figura.FiguraMod;
import org.figuramc.figura.avatar.AvatarManager;
import org.figuramc.figura.avatar.local.CacheAvatarLoader;
import org.figuramc.figura.avatar.local.LocalAvatarFetcher;
import org.figuramc.figura.backend2.NetworkStuff;
import org.figuramc.figura.config.ConfigType;
import org.figuramc.figura.entries.EntryPointManager;
import org.figuramc.figura.gui.FiguraToast;
import org.figuramc.figura.gui.screens.ConfigScreen;
import org.figuramc.figura.lua.FiguraLuaPrinter;
import org.figuramc.figura.lua.api.ConfigAPI;
import org.figuramc.figura.permissions.PermissionManager;
import org.figuramc.figura.permissions.Permissions;
import org.figuramc.figura.resources.FiguraRuntimeResources;
import org.figuramc.figura.utils.ColorUtils;
import org.figuramc.figura.utils.FiguraText;

public class Configs {
    public static final int CONFIG_VERSION = 1;
    public static final HashMap<Integer, HashMap<ConfigType<?>, String>> CONFIG_UPDATES = new HashMap();
    public static final ConfigType.Category NAMEPLATE = new ConfigType.Category("nameplate");
    public static final ConfigType.Category SCRIPT = new ConfigType.Category("script");
    public static final ConfigType.Category RENDERING = new ConfigType.Category("rendering");
    public static final ConfigType.Category ACTION_WHEEL = new ConfigType.Category("action_wheel");
    public static final ConfigType.Category UI = new ConfigType.Category("ui");
    public static final ConfigType.Category PAPERDOLL = new ConfigType.Category("paperdoll");
    public static final ConfigType.Category MISC = new ConfigType.Category("misc");
    public static final ConfigType.Category DEV = new ConfigType.Category("dev"){
        {
            this.name = this.name.copy().withStyle(ChatFormatting.RED);
        }
    };
    public static final ConfigType.Category NETWORKING = new ConfigType.Category("networking"){
        {
            this.name = this.name.copy().withStyle(ChatFormatting.RED);
            this.tooltip = this.tooltip.copy().withStyle(ChatFormatting.RED);
        }
    };
    public static final ConfigType.BoolConfig SELF_NAMEPLATE = new ConfigType.BoolConfig("self_nameplate", NAMEPLATE, (Boolean)false);
    public static final ConfigType.BoolConfig PREVIEW_NAMEPLATE = new ConfigType.BoolConfig("preview_nameplate", NAMEPLATE, (Boolean)false);
    public static final ConfigType.BoolConfig SOUND_BADGE = new ConfigType.BoolConfig("sound_badge", NAMEPLATE, (Boolean)true);
    private static final String NAMEPLATE_PATH = "config.nameplate_level.";
    private static final List<Component> NAMEPLATE_ENUM = List.of(FiguraText.of("config.nameplate_level.1"), FiguraText.of("config.nameplate_level.2"), FiguraText.of("config.nameplate_level.3"));
    private static final List<Component> NAMEPLATE_TOOLTIP = List.of(FiguraText.of("config.nameplate_level.1.tooltip"), FiguraText.of("config.nameplate_level.2.tooltip"), FiguraText.of("config.nameplate_level.3.tooltip"));
    public static final ConfigType.EnumConfig NAMEPLATE_RENDER = new ConfigType.EnumConfig("nameplate_render", NAMEPLATE, 0, 3);
    public static final ConfigType.EnumConfig CHAT_NAMEPLATE = new ConfigType.EnumConfig("chat_nameplate", NAMEPLATE, 2, 3){
        {
            this.enumList = NAMEPLATE_ENUM;
            this.enumTooltip = NAMEPLATE_TOOLTIP;
        }
    };
    public static final ConfigType.EnumConfig ENTITY_NAMEPLATE = new ConfigType.EnumConfig("entity_nameplate", NAMEPLATE, 2, 3){
        {
            this.enumList = NAMEPLATE_ENUM;
            this.enumTooltip = NAMEPLATE_TOOLTIP;
        }
    };
    public static final ConfigType.EnumConfig LIST_NAMEPLATE = new ConfigType.EnumConfig("list_nameplate", NAMEPLATE, 2, 3){
        {
            this.enumList = NAMEPLATE_ENUM;
            this.enumTooltip = NAMEPLATE_TOOLTIP;
        }
    };
    public static final ConfigType.EnumConfig LOG_LOCATION = new ConfigType.EnumConfig("log_location", SCRIPT, 0, 2);
    public static final ConfigType.EnumConfig FORMAT_SCRIPT = new ConfigType.EnumConfig("format_script", SCRIPT, 1, 4){
        {
            String tooltip = "config.format_script.tooltip.";
            this.tooltip = FiguraText.of(tooltip + "1").append("\n").append((Component)FiguraText.of(tooltip + "2").withStyle(ChatFormatting.RED));
        }

        @Override
        public void onChange() {
            if (!AvatarManager.localUploaded) {
                AvatarManager.reloadAvatar(FiguraMod.getLocalPlayerUUID());
            }
        }
    };
    public static final ConfigType.PositiveIntConfig LOG_NUMBER_LENGTH = new ConfigType.PositiveIntConfig("log_number_length", SCRIPT, 5){

        @Override
        public void onChange() {
            super.onChange();
            FiguraLuaPrinter.updateDecimalFormatting();
        }
    };
    public static final ConfigType.EnumConfig IRIS_COMPATIBILITY_FIX = new ConfigType.EnumConfig("iris_compatibility_fix", RENDERING, 1, 3);
    public static final ConfigType.EnumConfig RENDER_DEBUG_PARTS_PIVOT = new ConfigType.EnumConfig("render_debug_parts_pivot", RENDERING, 1, 3){
        {
            String tooltip = "config.render_debug_parts_pivot.tooltip";
            this.tooltip = FiguraText.of(tooltip, FiguraText.of(tooltip + ".cubes").setStyle(ColorUtils.Colors.AWESOME_BLUE.style), FiguraText.of(tooltip + ".groups").setStyle(ColorUtils.Colors.FIGURA_BLUE.style));
        }
    };
    public static final ConfigType.BoolConfig ALLOW_FP_HANDS = new ConfigType.BoolConfig("allow_fp_hands", RENDERING, (Boolean)false);
    public static final ConfigType.BoolConfig FIRST_PERSON_MATRICES = new ConfigType.BoolConfig("first_person_matrices", RENDERING, (Boolean)true);
    public static final ConfigType.BoolConfig INVENTORY_SCISSOR = new ConfigType.BoolConfig("inventory_scissor", RENDERING, (Boolean)true);
    public static final ConfigType.KeybindConfig ACTION_WHEEL_BUTTON = new ConfigType.KeybindConfig("action_wheel_button", ACTION_WHEEL, "key.keyboard.b");
    public static final ConfigType.EnumConfig ACTION_WHEEL_MODE = new ConfigType.EnumConfig("action_wheel_mode", ACTION_WHEEL, 0, 4);
    public static final ConfigType.PositiveFloatConfig ACTION_WHEEL_SCALE = new ConfigType.PositiveFloatConfig("action_wheel_scale", ACTION_WHEEL, 1.0f);
    public static final ConfigType.EnumConfig ACTION_WHEEL_TITLE = new ConfigType.EnumConfig("action_wheel_title", ACTION_WHEEL, 0, 7);
    public static final ConfigType.EnumConfig ACTION_WHEEL_SLOTS_INDICATOR = new ConfigType.EnumConfig("action_wheel_slots_indicator", ACTION_WHEEL, 0, 3);
    public static final ConfigType.BoolConfig ACTION_WHEEL_DECORATIONS = new ConfigType.BoolConfig("action_wheel_decorations", ACTION_WHEEL, (Boolean)true);
    public static final ConfigType.BoolConfig FIGURA_INVENTORY = new ConfigType.BoolConfig("figura_inventory", UI, (Boolean)true);
    public static final ConfigType.BoolConfig PREVIEW_HEAD_ROTATION = new ConfigType.BoolConfig("preview_head_rotation", UI, (Boolean)false);
    public static final ConfigType.BoolConfig AVATAR_PORTRAIT = new ConfigType.BoolConfig("avatar_portrait", UI, (Boolean)true);
    public static final ConfigType.BoolConfig WARDROBE_FILE_NAMES = new ConfigType.BoolConfig("wardrobe_file_names", UI, (Boolean)false);
    public static final ConfigType.FloatConfig BACKGROUND_SCROLL_SPEED = new ConfigType.FloatConfig("background_scroll_speed", UI, 1.0f);
    public static final ConfigType.PositiveFloatConfig POPUP_SCALE = new ConfigType.PositiveFloatConfig("popup_scale", UI, 1.0f);
    public static final ConfigType.PositiveFloatConfig POPUP_MIN_SIZE = new ConfigType.PositiveFloatConfig("popup_min_size", UI, 1.0f);
    public static final ConfigType.PositiveFloatConfig POPUP_MAX_SIZE = new ConfigType.PositiveFloatConfig("popup_max_size", UI, 6.0f);
    public static final ConfigType.PositiveFloatConfig TOAST_TIME = new ConfigType.PositiveFloatConfig("toast_time", UI, 5.0f);
    public static final ConfigType.PositiveFloatConfig TOAST_TITLE_TIME = new ConfigType.PositiveFloatConfig("toast_title_time", UI, 2.0f);
    public static final ConfigType.PositiveFloatConfig TEXT_SCROLL_SPEED = new ConfigType.PositiveFloatConfig("text_scroll_speed", UI, 1.0f);
    public static final ConfigType.PositiveIntConfig TEXT_SCROLL_DELAY = new ConfigType.PositiveIntConfig("text_scroll_delay", UI, 20);
    public static final ConfigType.BoolConfig REDUCED_MOTION = new ConfigType.BoolConfig("reduced_motion", UI, (Boolean)false);
    public static final ConfigType.BoolConfig HAS_PAPERDOLL = new ConfigType.BoolConfig("has_paperdoll", PAPERDOLL, (Boolean)false);
    public static final ConfigType.BoolConfig PAPERDOLL_ALWAYS_ON = new ConfigType.BoolConfig("paperdoll_always_on", PAPERDOLL, (Boolean)false);
    public static final ConfigType.BoolConfig FIRST_PERSON_PAPERDOLL = new ConfigType.BoolConfig("first_person_paperdoll", PAPERDOLL, (Boolean)true);
    public static final ConfigType.BoolConfig PAPERDOLL_INVISIBLE = new ConfigType.BoolConfig("paperdoll_invisible", PAPERDOLL, (Boolean)false);
    public static final ConfigType.FloatConfig PAPERDOLL_SCALE = new ConfigType.FloatConfig("paperdoll_scale", PAPERDOLL, 1.0f);
    public static final ConfigType.FloatConfig PAPERDOLL_X = new ConfigType.FloatConfig("paperdoll_x", PAPERDOLL, 0.0f);
    public static final ConfigType.FloatConfig PAPERDOLL_Y = new ConfigType.FloatConfig("paperdoll_y", PAPERDOLL, 0.0f);
    public static final ConfigType.FloatConfig PAPERDOLL_PITCH = new ConfigType.FloatConfig("paperdoll_pitch", PAPERDOLL, 0.0f);
    public static final ConfigType.FloatConfig PAPERDOLL_YAW = new ConfigType.FloatConfig("paperdoll_yaw", PAPERDOLL, 20.0f);
    public static final ConfigType.KeybindConfig POPUP_BUTTON = new ConfigType.KeybindConfig("popup_button", MISC, "key.keyboard.r");
    public static final ConfigType.KeybindConfig RELOAD_BUTTON = new ConfigType.KeybindConfig("reload_button", MISC, "key.keyboard.unknown");
    public static final ConfigType.KeybindConfig PANIC_BUTTON = new ConfigType.KeybindConfig("panic_button", MISC, "key.keyboard.unknown");
    public static final ConfigType.KeybindConfig WARDROBE_BUTTON = new ConfigType.KeybindConfig("wardrobe_button", MISC, "key.keyboard.unknown");
    public static final ConfigType.EnumConfig BUTTON_LOCATION = new ConfigType.EnumConfig("button_location", MISC, 0, 5);
    public static final ConfigType.EnumConfig UPDATE_CHANNEL = new ConfigType.EnumConfig("update_channel", MISC, 1, 3){

        @Override
        public void onChange() {
            super.onChange();
            NetworkStuff.checkVersion();
        }
    };
    public static final ConfigType.EnumConfig DEFAULT_PERMISSION_LEVEL = new ConfigType.EnumConfig("default_permission_level", MISC, 2, Permissions.Category.values().length){
        {
            Permissions.Category[] categories;
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            for (Permissions.Category category2 : categories = Permissions.Category.values()) {
                list.add(category2.text.copy());
            }
            this.enumList = list;
            this.enumTooltip = null;
        }

        @Override
        public void onChange() {
            super.onChange();
            PermissionManager.saveToDisk();
        }
    };
    public static final ConfigType.EnumConfig EMOJIS = new ConfigType.EnumConfig("emojis", MISC, 1, 3);
    public static final ConfigType.BoolConfig EASTER_EGGS = new ConfigType.BoolConfig("easter_eggs", MISC, (Boolean)true);
    public static final ConfigType.BoolConfig DEBUG_MODE = new ConfigType.BoolConfig("debug_mode", DEV, false, false);
    public static final ConfigType.BoolConfig LOCAL_ASSETS = new ConfigType.BoolConfig("local_assets", DEV, false, false);
    public static final ConfigType.BoolConfig CONNECTION_TOASTS = new ConfigType.BoolConfig("connection_toasts", DEV, (Boolean)true);
    public static final ConfigType.BoolConfig LOG_OTHERS = new ConfigType.BoolConfig("log_others", DEV, (Boolean)false);
    public static final ConfigType.EnumConfig LOG_PINGS = new ConfigType.EnumConfig("log_pings", DEV, 0, 3);
    public static final ConfigType.BoolConfig SYNC_PINGS = new ConfigType.BoolConfig("sync_pings", DEV, (Boolean)false){
        {
            String tooltip = "config.sync_pings.tooltip.";
            this.tooltip = FiguraText.of(tooltip + "1").append("\n").append((Component)FiguraText.of(tooltip + "2").withStyle(ChatFormatting.RED));
        }
    };
    public static final ConfigType.BoolConfig CHAT_MESSAGES = new ConfigType.BoolConfig("chat_messages", DEV, (Boolean)false){
        {
            this.name = this.name.copy().withStyle(ChatFormatting.RED);
            String tooltip = "config.chat_messages.tooltip.";
            this.tooltip = FiguraText.of(tooltip + "1").append("\n\n").append((Component)FiguraText.of(tooltip + "2").withStyle(ChatFormatting.RED)).append("\n\n").append((Component)FiguraText.of(tooltip + "3").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
        }
    };
    public static final ConfigType.FolderConfig MAIN_DIR = new ConfigType.FolderConfig("main_dir", DEV, ""){

        @Override
        public void onChange() {
            super.onChange();
            PermissionManager.reinit();
            LocalAvatarFetcher.reinit();
            EntryPointManager.reinit();
        }
    };
    public static final ConfigType.IPConfig SERVER_IP = new ConfigType.IPConfig("server_ip", DEV, "figura.moonlight-devs.org"){

        @Override
        public void onChange() {
            super.onChange();
            NetworkStuff.reAuth();
        }
    };
    public static final ConfigType.ButtonConfig CLEAR_CACHE = new ConfigType.ButtonConfig("clear_cache", DEV, () -> {
        CacheAvatarLoader.clearCache();
        LocalAvatarFetcher.clearCache();
        ConfigScreen.clearCache();
        FiguraRuntimeResources.clearCache();
        FiguraToast.sendToast(FiguraText.of("toast.cache_clear"));
    });
    public static final ConfigType.ButtonConfig REDOWNLOAD_ASSETS = new ConfigType.ButtonConfig("redownload_assets", DEV, () -> {
        FiguraRuntimeResources.init();
        Minecraft.getInstance().reloadResourcePacks();
    });
    public static final ConfigType.ButtonConfig CLEAR_AVATAR_DATA = new ConfigType.ButtonConfig("clear_avatar_data", DEV, () -> {
        ConfigAPI.clearAllData();
        FiguraToast.sendToast(FiguraText.of("toast.avatar_data_clear"));
    });
    public static final ConfigType.BoolConfig FORCE_SMOOTH_AVATAR = new ConfigType.BoolConfig("force_smooth_avatar", DEV, (Boolean)false);
    public static final ConfigType.BoolConfig GUI_FPS = new ConfigType.BoolConfig("gui_fps", DEV, (Boolean)false);
    public static final ConfigType.BoolConfig ALLOW_NETWORKING = new ConfigType.BoolConfig("allow_networking", NETWORKING, (Boolean)false);
    public static final ConfigType.EnumConfig NETWORKING_RESTRICTION = new ConfigType.EnumConfig("networking_restriction", NETWORKING, 0, 3);
    public static final ConfigType.NetworkFilterConfig NETWORK_FILTER = new ConfigType.NetworkFilterConfig("network_filter", NETWORKING);
    public static final ConfigType.EnumConfig LOG_NETWORKING = new ConfigType.EnumConfig("networking_logging", NETWORKING, 0, 4);

    public static void init() {
        if (FiguraMod.debugModeEnabled()) {
            ConfigType.Category debug = new ConfigType.Category("debug");
            new ConfigType.ColorConfig("color_test", debug, ColorUtils.Colors.AWESOME_BLUE.hex);
            new ConfigType.StringConfig("string_test", debug, "text");
            new ConfigType.IntConfig("int_test", debug, Integer.MAX_VALUE);
        }
    }
}

